#include "mode.h"


namespace lp {

	//====================== Methods ======================//

	//Mode& Mode::operator=(const Mode& m)
	//{
	//	if (this != &m) {
	//		_head = m._head;
	//		_recall = m._recall;
	//		_max_occurs = m._max_occurs;
	//		_functional = m._functional;
	//		_reflexive = m._reflexive;
	//		_atom = m._atom;
	//		placemarkers = m.placemarkers;
	//	}
	//	return *this;
	//}


	Mode& Mode::operator=(Mode&& m)
	{
		if (this != &m)
		{
			props = std::move(m.props);
			_atom = move(m._atom);
			placemarkers = move(m.placemarkers);
		}
		return *this;
	}


	bool Mode::operator<(const Mode& m) const
	{
		// Compare mode: modeh are always smaller than modeb
		if (std::lexicographical_compare(props.begin(),props.end(),m.props.begin(),m.props.end())) {
			return true;
		} else if (std::lexicographical_compare(m.props.begin(),m.props.end(),props.begin(),props.end())) {
			return false;
		}
		// Compare declarations
		return functor_less()(atom(),m.atom());
	}


	void Mode::initpm()
	{
		//cerr << "atom: " << atom() << "\n";
		for (const Functor& n : atom()) {
			auto mtype = this->get_marker(n);
			if (mtype != Mode::normal)
			{
				//Functor::position pos(n); // position of this node
				pmarker pm;
				pm.pos = Functor::position(&n); // position of this node
				pm.iotype = mtype;
				pm.type = n.arg_first()->id();
				//cerr << "Mode, adding pm " << pm.pos << " , " << pm.iotype << ", " << pm.type << "\n";
				placemarkers.push_back( move(pm) );
			}
		}
	}




	// Prototype guarantees to deliver variables as _P1, _P2, ...
	// This is needed for more efficient bottom clause computation (see memoization)
	Functor Mode::prototype() const
	{
		// Define replacement for place-markers
		Functor prot = atom();
		std::for_each(prot.post_begin(),prot.post_end(),[&](Functor& n){
			marker m = this->get_marker(n);
			if (m != Mode::normal) {
				// Note: #types are also replaced with variables
				n = Functor(Functor::unique_index());
			}
		});
		return prot;
	}


	//Clause Mode::generating_clause() const
	//{
	//	Clause gen = prototype();
	//	unique_ptr<Functor> gbody(new Functor(if_id)); // generated body literals
	//	Functor* last = nullptr; // last literal added to gbody (efficiency)
	//	// Create body literals for each occurrence of type
	//	for (auto pm = begin(); pm != end(); ++pm) {
	//		// pm->type is the type of variable var
	//		const Functor* fvar = gen.get(pm->pos);
	//		assert( fvar->is_variable() );
	//		const id_type var = fvar->id();
	//		Functor* bl = new Functor(pm->type, new Functor(var));
	//		gbody->body_push_back(bl,last);
	//		last = bl;
	//	}
	//	gen.body( gbody->body_release() );
	//	return gen;
	//}


	void Mode::print(ostream& os) const
	{
		is_head() ? os << "modeh" : os << "modeb";
		os << "(";
		recall() == numeric_limits<int>::max() ? os << "*" : os << recall();
		os << ",";
		os << atom();
		bool has_special = false;
		for (decltype(props.size()) k = 0; k < props.size(); ++k) {
			if (k == prop::head || k == prop::rec) continue;
			if (k == prop::maxc) {
				if (props[k] != std::numeric_limits<int>::max()) {
					has_special = true;
					break;
				}
			} else {
				if (props[k] != 0) {
					has_special = true;
					break;
				}
			}
		}
		if (has_special) {
			string sep = "";
			os << ",[";
			if (max_occurs() != numeric_limits<int>::max()) {
				os << sep << max_occurs();
				sep = ",";
			}
			if (props[prop::functional]) {
				os << sep << "functional";
				sep = ",";
			}
			if (props[prop::reflexive]) {
				os << sep << (props[prop::reflexive] < 0 ? "anti-" : "") << "reflexive";
				sep = ",";
			}
			if (props[prop::symmetric]) {
				os << sep << (props[prop::symmetric] < 0 ? "anti-" : "") << "symmetric";
				sep = ",";
			}
			if (props[prop::idempotent]) {
				os << sep << "idempotent";
				sep = ",";
			}
			if (props[prop::transitive]) {
				os << sep << "transitive";
				sep = ",";
			}
			os << "]";
			assert(sep == ","); // check that at least one property was listed
		}
		os << ").";
	}


	io_map make_io_map(const Functor& bot, const std::vector<Mode>& modes)
	{
		assert( modes.size() == bot.body_size()+1 );
		io_map iovars;
		set<id_type> invars,outvars;
		const Mode& modeh = modes[0];
		//std::cerr << "make_io_map, bot: " << bot << "\n";
		//std::cerr << "make_io_map, modeh: " << modeh << "\n";
		modeh.variables(Mode::input, *bot.head(), invars);
		modeh.variables(Mode::output, *bot.head(), outvars);
		// cerr << "Head input variables: "; for_each(invars.begin(),invars.end(),[&](id_type v){ cerr << fmap.get_data(v) << " ";}); cerr << "\n";
		iovars.push_back(std::make_pair(std::move(invars),std::move(outvars)));
		// cerr << "Head output variables: "; for_each(outvars.begin(),outvars.end(),[&](id_type v){ cerr << fmap.get_data(v) << " ";}); cerr << "\n";
		int k = 1;
		for (auto l = bot.body_begin(); l != bot.body_end(); ++l,++k){
			const Mode& modeb = modes[k];
			assert(modeb);
			invars.clear();
			outvars.clear();
			if (!l->is_constant(true_id)) {
				//cerr << "Make_io_map, Body literal: " << l << "\n";
				modeb.variables(Mode::input, *l, invars);
				// cerr << " input variables: "; for_each(invars.begin(),invars.end(),[](id_type v){ cerr << fmap.get_data(v) << " ";}); cerr << "\n";
				modeb.variables(Mode::output, *l, outvars);
				// cerr << " output variables: "; for_each(outvars.begin(),outvars.end(),[](id_type v){ cerr << fmap.get_data(v) << " ";}); cerr << "\n";
			}
			iovars.push_back(std::make_pair(std::move(invars),std::move(outvars)));
		}
		return iovars;
	}


	//============================= GLOBAL FUNCTIONS =============================//


	// Test chaining condition
	bool is_chained(const Functor& f, const io_map& iomap)
	{
		// Make sure all inputs in body are instantiated before use
		std::set<id_type> instantiated = iomap[0].first; // inputs from head
		int k = 1;
		for (auto l = f.body_begin(); l != f.body_end(); ++l,++k) {
			if (l->is_constant(true_id)) continue;
			// Check instantiation
			const set<id_type>& inputs = iomap[k].first;
			// Are all inputs instantiated?
			for (auto i = inputs.begin(); i != inputs.end(); ++i) {
				if (instantiated.find(*i) == instantiated.end()) return false;
			}
			// Add output variables to instantiated
			const set<id_type>& outputs = iomap[k].second;
			//for_each(outputs.begin(),outputs.end(),[&](id_type v){ instantiated.insert(v); });
			instantiated.insert(outputs.begin(),outputs.end());
		}
		return true;
	}

	// Test argument condition (all head outputs are used)
	bool is_returned(const Functor& f, const io_map& iomap)
	{
		// Compute all instantiated = head inputs + body outputs
		std::set<id_type> instantiated = iomap[0].first; // inputs from head
		int k = 1;
		for (auto l = f.body_begin(); l != f.body_end(); ++l,++k) {
			if (l->is_constant(true_id)) continue;
			// Add output variables to instantiated
			const std::set<id_type>& outputs = iomap[k].second;
			//for_each(outputs.begin(),outputs.end(),[&](id_type v){ instantiated.insert(v); });
			instantiated.insert(outputs.begin(),outputs.end());
		}
		const std::set<id_type>& head_out = iomap[0].second;
		for (auto i = head_out.begin(); i != head_out.end(); ++i) {
			if (instantiated.find(*i) == instantiated.end()) return false;
		}
		return true;
	}

	// Test argument condition (all head inputs are used)
	bool is_argument(const Functor& f, const io_map& iomap)
	{
		set<id_type> unused = iomap[0].first; // inputs from head
		// If head outputs an input, ignore it
		const auto& headout = iomap[0].second;
		std::for_each(headout.begin(),headout.end(),[&](const id_type v){ unused.erase(v); });
		int k = 1;
		for (auto l = f.body_begin(); l != f.body_end(); ++l,++k) {
			if (l->is_constant(true_id)) continue;
			// See if output variables matches head input
			const set<id_type>& outputs = iomap[k].second;
			for_each(outputs.begin(),outputs.end(),[&](const id_type v){ unused.erase(v); });
			if (unused.empty()) break; // pre-terminate if we've finished
		}
		return unused.empty();
	}

	bool is_mode_conformant(
		const Functor& cand,
		const parameters& params, 
		const io_map& iomap)
	{
		if (params.is_set(parameters::chain_io) && !is_chained(cand,iomap)) {
			// Not IO chained
			DEBUG_INFO(cout << "Skipping unchained: " << cand << "\n");
			return false;
		} else if (params.is_set(parameters::chain_return) && !is_returned(cand,iomap)) {
			// output un-instantiated
			DEBUG_INFO(cout << "Skipping chain unreturned: " << cand << "\n");
			return false;
		} else if (params.is_set(parameters::chain_arguments) && !is_argument(cand,iomap)) {
			// argument unused
			DEBUG_INFO(cout << "Skipping chain input unused: " << cand << "\n");
			return false;
		} else {
			return true;
		}
	}


}

